   /**HEADER********************************************************************
* 
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 2004-2008 Embedded Access Inc.;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: timer_fxlc95000.h$
* $Version : 1.0.0.0$
* $Date    : Nov-10-2011$
*
* Comments:
*
*   This file contains definitions for the FXLC95000 programmable
*   interrupt timer utility functions.
*
*END************************************************************************/

#ifndef __timer_fxlc95000_h__
#define __timer_fxlc95000_h__

#ifndef __int_ctrl_fxlc95000_h__
#include <int_ctrl_fxlc95000.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

	
	
	
/*-----------------------------------------------------------------------*/
/*                      DEFINITIONS
*/



#if (BSP_TIMER == BSP_TIMER_USE_TPM)

  #define _fxlc95000_timer_mask_int() { TPMSC &= 0x3f; }
  #define _fxlc95000_timer_unmask_int() { TPMSC |= TPMxSC_TOIE_MASK; }
  #define _fxlc95000_timer_clear_int() { TPMSC &= ~TPMxSC_TOF_MASK; }

  // Adjust for TPM prescaler: b[2:0] is prescaler
  // 0 - TPM clk divide by 1
  // 1 - TPM clk divide by 2
  // 2 - TPM clk divide by 4
  // 3 - TPM clk divide by 8
  // 4 - TPM clk divide by 16
  // 5 - TPM clk divide by 32
  // 6 - TPM clk divide by 64
  #define GET_PICOSEC_PER_TICK(picosec_per_clk_tick)   (picosec_per_clk_tick << (TPMSC & 0x07))


#elif (BSP_TIMER == BSP_TIMER_USE_PDB)

  //#define _fxlc95000_timer_mask_int() { PDB_SCR &= ~PDB_SCR_IENA_MASK;  FCSR &= ~FCSR_SFDIE_MASK; }
  //#define _fxlc95000_timer_unmask_int() { PDB_SCR |= PDB_SCR_IENA_MASK; FCSR |= FCSR_SFDIE_MASK; }
  //#define _fxlc95000_timer_clear_int() { PDB_SCR |= (1 << 11); FCSR &= ~FCSR_SF_MASK; }

  extern void _fxlc95000_timer_mask_int(void); 

  extern void _fxlc95000_timer_unmask_int(void); 

  extern void _fxlc95000_timer_clear_int(void); 

  // Adjust for PDB prescaler: b[15:13]
  // 0 - PDB clk divide by 1
  // 1 - PDB clk divide by 2
  // 2 - PDB clk divide by 4
  // 3 - PDB clk divide by 8
  // 4 - PDB clk divide by 16
  // 5 - PDB clk divide by 32
  // 6 - PDB clk divide by 64
  // 7 - PDB clk divide by 128
  #define GET_PICOSEC_PER_TICK(picosec_per_clk_tick)     (picosec_per_clk_tick << ( (PDB_SCR >> 13) & 0x07))

#endif




/*-----------------------------------------------------------------------*/
/*                      FUNCTION PROTOTYPES
*/

#if (BSP_TIMER == BSP_TIMER_USE_TPM)
  extern uint_32 _fxlc95000_timer_init_int(uint_32, boolean unmask);
#elif (BSP_TIMER == BSP_TIMER_USE_PDB)
  extern uint_32 _fxlc95000_timer_init_int(boolean unmask);
  extern volatile uint_8 gRtos_current_FLE;
#endif


extern uint_32 _fxlc95000_timer_init_freq(uint_32, boolean unmask);
extern uint_32 _fxlc95000_get_hwticks(void);
extern uint_32 _fxlc95000_timer_get_nsec(uint_32);
extern uint_32 _fxlc95000_timer_get_usec(uint_32);

#ifdef __cplusplus
}
#endif

#endif
/* EOF */
